@mainpage Sequoyah -- a Unicode Cherokee to ASCII Transliteration Utility

INTRODUCTION
============

The Sequoyah package converts between UTF-8-encoded Unicode
Cherokee syllables and ASCII transliterations, which follow
the Unicode code chart transliterations for Unicode ranges
U+13A0..U+13FF (Cherokee) and U+AB70..U+ABBF (Cherokee Supplement).

The intention is that this program will facilitate typing
Cherokee using Sequoyah's syllabary by using the ASCII
syllable transliterations that appear in the Unicode Standard.

For a list of the transliteration mappings, see the file
"sequoyah-map.txt", which contains a table of Cherokee
syllables and their ASCII transliterations.  Better yet,
feed the file into the "sequoyah" program to see the
transliteration columns flipped!


Building
--------

To build the package, simply type

      make

This will convert the lex (or GNU flex) source file into
C if it has been modified, and then compile the C program
into the "sequoyah" executable.

To rebuild the Doxygen HTML output, type

      make doxy

Note that running Doxygen will require installation of the
"graphviz", "texlive", "texlive-latex-extra", and "doxygen"
packages on your system.

To build the Doxygen output completely from scratch, remove
the subdirectory "doxy" and the file "sequoyah.html", and
then run "make doxy".


Testing
-------

To check the "sequoyah" program, type

      make check

This will convert the input file "sequoyah-map.txt" into the
file "sequoyah2ascii.txt", and then convert that file into the
file "round-trip.txt".  The "round-trip.txt" is then compared
with the original input file, "sequoyah-map.txt".  If there
are no differences, the check passes.


Installing
----------

To install the package files, type

      sudo make install

With the default Makefile settings, this command will install
the "sequoyah" executable program into /usr/local/bin, the
"sequoyah.1" man page into /usr/local/share/man/man1, and the
Sequoyah package text files (including Doxygen documentation)
into /usr/local/share/sequoyah.

Following a "make install", the "sequoyah" binary file and
intermediate build and test files can be removed with

      make distclean


Uninstalling
------------

To uninstall the installed files, type

      sudo make uninstall


Cleaning Up
-----------

To remove intermediate files from building and testing, type

      make clean

To remove all files except the original package files, type

      make distclean


Creating a Tarball
------------------

To create a new tarball of files one level above the source
directory, type

      make dist

This will create the file "sequoyah-<version>.tar.gz" one
level above the top-level source directory.


LICENSE
-------

      This program is free software: you can redistribute it and/or modify
      it under the terms of the GNU General Public License as published by
      the Free Software Foundation, either version 2 of the License, or
      (at your option) any later version.

      This program is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
      GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
      along with this program.  If not, see <http://www.gnu.org/licenses/>.

